# Intra-class mixup for Out-of-Distribution Detection

Requirements
------------
The code has been developed with pytorch and we recommend using conda package manager. For convenience of setting up the environment we provide a requirements.txt file which can be used with the command below to install all the requirements for this repository
```
pip install -r requirements.txt
```

How to train intra-class mixup models?
------------------------
Create a folder "./pretrained/\<dataset name\>" and "./pretrained/\<dataset name\>/temp"
i.e. 
```
mkdir pretrained
mkdir pretrained/cifar10
mkdir pretrained/cifar10/temp
```
And update the dataset paths in ./utils/load_dataset.py

To train intra-class mixup models use train.py. An example command looks like
```
python train.py --dataset=cifar10 --epochs=350 --vrm=t --suffix=vrm_1
```
This trains a intra-class mixup model on cifar10 with VRM for 350 epochs. Set --vrm=f to perform standard training. The training code offers more control, however default params are a good starting point. Use -h to list all the available hyperparameter controls.


The training code supports the following datasets
* [CIFAR-10](https://www.cs.toronto.edu/~kriz/cifar.html)
* [CIFAR-100](https://www.cs.toronto.edu/~kriz/cifar.html)
* [SVHN](http://ufldl.stanford.edu/housenumbers/)
* [TinyImageNet](http://cs231n.stanford.edu/tiny-imagenet-200.zip)
* [Places365](http://places2.csail.mit.edu/index.html)
* [LSUN](https://www.yf.io/p/lsun)
* [iSUN](http://turkergaze.cs.princeton.edu/)
* [Textures](https://www.robots.ox.ac.uk/~vgg/data/dtd/)

The code uses a validation iSUN dataset which is a resized version available [here](https://www.dropbox.com/s/ssz7qxfqae0cca5/iSUN.tar.gz) used by the authors of  https://github.com/ShiyuLiang/odin-pytorch

How to obtain comparison results?
---------------------------------
The ./methods folder contains various refactors of official implementations
of 
* [MSP](https://github.com/hendrycks/error-detection)
* [ODIN](https://github.com/ShiyuLiang/odin-pytorch) and
* [Energy Based detection](https://github.com/wetliu/energy_ood/)

To run an averaged results tabulation of each methods copy/train the models with different seeds and specify the seeds using the --suffixs argument and run
```
python comparison.py --method=msp --outfile=msp.txt
```

The --method specifies the technique and the output file compares VRM and ERM trained models on 3 metrics, AUROC, AUPR and FPR95. Append "_polar" to use angular margin. For example 'msp_polar' or 'odin_polar' or 'energy_score_polar'. 

Supported methods
* msp
* odin
* energy_score

Similarly use train_inter_mixup.py to train inter-class mixup models

Separability
------------
To obtain separability numbers run the save_latent_space_vectors.py, which saves the latent representations for various models and the run sep.py. Default sep.py saves the mean angular margin. To save the spread save array indices 4 and 6 in lines 190 and 213 instead of 3 and 5.

Resources used
---------------
The results presented used a setup with 2 Nvidia Titan Xp GPUs and 16GB of RAM with intel i7-10700F processor. To reproduce the results the estimated GPU hours is equivalent to about 2 weeks of continuous single GPU usage, mostly accounting for training the various seeds of the models

Pretrained models
-----------------
Pretrained models are available [here](https://drive.google.com/file/d/1R3IOFswfv0WyVBivixp9-4I9TMp3B8Z3/view?usp=sharing).
The models are named based on their tranining scheme and seed. 
* erm - Empirical Risk Minimization
* vrm - Intra-class mixup
* mixup - Inter-class mixup
